#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_KEM_SP_J						96
#define KAZ_KEM_SP_SL						192

#define KAZ_KEM_SP_N						"15982040643598444277320371265136974856402799594720686504760818091215333991414038871394426514903965899103553442859146701270930684879295849706045338879593833465052745734862675359470536861467492521046077102660572015"
#define KAZ_KEM_SP_LN						702 // in binary (88 bytes)

#define KAZ_KEM_SP_g1						"7"
#define KAZ_KEM_SP_g2						"23"
#define KAZ_KEM_SP_g3						"65537"

#define KAZ_KEM_SP_Og1N						"51736000959480087314595638140051513827162226171393634016000"
#define KAZ_KEM_SP_LOg1N					196 // in binary (25 bytes)
#define KAZ_KEM_SP_Og2N						"38802000719610065485946728605038635370371669628545225512000"
#define KAZ_KEM_SP_LOg2N					195 // in binary (25 bytes)
#define KAZ_KEM_SP_Og3N						"12934000239870021828648909535012878456790556542848408504000"
#define KAZ_KEM_SP_LOg3N					194 // in binary (25 bytes)

#define KAZ_KEM_PUBLICKEY_BYTES				88 // in bytes for each A1, A2, A3
#define KAZ_KEM_PRIVATEKEY_BYTES			25 // in bytes for each a1, a2, a3

#define KAZ_KEM_EPHERMERAL_PUBLIC_BYTES		88 // in bytes for each B1, B2, B3
#define KAZ_KEM_EPHERMERAL_PRIVATE_BYTES	25 // in bytes for each b1, b2, b3

#define KAZ_KEM_GENERAL_BYTES				88 // in bytes for message, encapsulate message, decapsulate message

extern void KAZ_KEM_RANDOM(mpz_t lb, mpz_t ub, mpz_t out);

extern int KAZ_KEM_KEYGEN(unsigned char *kaz_kem_public_key,
                           unsigned char *kaz_kem_private_key);

extern int KAZ_KEM_ENCAPSULATION(unsigned char *encapsulation, unsigned long long *encaplen,
                                 const unsigned char *m, unsigned long long mlen,
                                 const unsigned char *kaz_kem_public_key);

extern int KAZ_KEM_DECAPSULATION(unsigned char *decapsulation, unsigned long long *decaplen,
                                 const unsigned char *encapsulation, unsigned long long encaplen,
                                 const unsigned char *kaz_kem_private_key);

#endif // FILE_H_INCLUDED
